<?php
// ============================================================================
// GD-CMS: A heirarchical content management system
// Version 2.0:20121009
// ============================================================================
//
// Copyright (c) 2010-2012 General Development
//
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without
// restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following
// conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
// ============================================================================
// 
// requires at least PHP verion 4.3 (for file_get_contents)
// Tested with PHP 5.2.10.



// Parameters:
// $_GET['l1'], $_GET['l2'],...etc. The sections of each level of the menu heirarchy tree to descend into until a file (not directory) is encountered.

//The following global variables assume default values unless set by the user.
if(!isset($gdcms_url_rewrite)) $gdcms_url_rewrite = FALSE;
if(!isset($gdcms_href_prefix)) $gdcms_href_prefix = '';
if(!isset($gdcms_content_path)) $gdcms_content_path = dirname(__FILE__) . '/content/';
if(!isset($gdcms_double_encode)) $gdcms_double_encode = FALSE;
if(!isset($gdcms_auth_flags)) $gdcms_auth_flags = 0;


//populate an array of sections for each heirarchy level until we get down to a leaf node.
// (files are leaf nodes, directories are not)
$_gdcms_last_level_specified = 0;
for($level=1; ; $level++)
{
    if(isset($targettitle)) unset($targettitle);
    if(isset($candidatefile)) unset($candidatefile);
    if(isset($candidateaccessdenied)) unset($candidateaccessdenied);
    if(isset($candidateauthrequired)) unset($candidateauthrequired);
    if(isset($_GET['l'.$level])) {
        $_gdcms_last_level_specified = $level;
        $targettitle = stripslashes($_GET['l'.$level]);
    }

    $dirlisting[$level] = scandir($gdcms_content_path);

    foreach($dirlisting[$level] as $filename) {
        //parse the filename into index, title, etc.
        $delimpos = strpos($filename, '.');
        $designator = substr($filename, 0, $delimpos);
        if(!$designator) continue; //exclude 'files' like '..'
        $title = substr($filename, $delimpos+1);
        if(!is_dir($gdcms_content_path . $filename)) { //non-directories have a filename extension (exclude it)
            $delimpos = strrpos($title, '.');
            if($delimpos !== FALSE)
                $title = substr($title, 0, $delimpos);
        }

        $index = 0;
        while(strlen($designator) > 0 && ctype_digit($teststr = substr($designator, 0,1))) {
            $index .= $teststr;
            $designator = substr($designator, 1);
        }
        $index = intval($index);

        $hidden = (bool) strstr($designator, 'h');
        $default = (bool) strstr($designator, 'd');
        $redirect = (bool) strstr($designator, 'r');
        if(($teststr = strstr($designator, 'a')) != FALSE) { //content requires auth flag(s). 
            $accessdenied = TRUE;
            $authrequired = TRUE;
            if($gdcms_auth_flags) {
                $accessdenied = FALSE;
                do { //check each auth flag.
                    $teststr = substr($teststr, 1);
                    $testflag = 0;
                    while(strlen($teststr) > 0 && ctype_digit($testchar = substr($teststr, 0,1))) {
                        $testflag .= $testchar;
                        $teststr = substr($teststr, 1);
                    }
                    $testflag = intval($testflag);
                    
                    //check testflag against $gdcms_auth_flags...
                    $matchedflag = FALSE;
                    if(!$testflag) $matchedflag = TRUE; //no flag specified means 'match any auth flag'.
                    else if(is_array($gdcms_auth_flags)) {
                        foreach($gdcms_auth_flags as $flag) {
                            if($testflag == $flag) {
                                $matchedflag = TRUE;
                                break;
                            }
                        }
                    } else {
                        $matchedflag = ($testflag == $gdcms_auth_flags);
                    }
                    if(!$matchedflag) {
                        $accessdenied = TRUE;
                        break;
                    }
                } while(($teststr=strstr($teststr, 'a')) != FALSE);
                $teststr = $designator;
            }
        } else {
            $accessdenied = FALSE;
            $authrequired = FALSE;
        }
        if(strstr($designator, 't')) { //a template!
            if(!$accessdenied && !is_dir($gdcms_content_path . $filename)) {
                for($i=0; isset($_gdcms_template_title[$i]); $i++) {
                    if(strcasecmp($title, $_gdcms_template_title[$i])==0) 
                        break; //we will override this match
                }
                $_gdcms_template_title[$i] = $title;
                $_gdcms_template_file[$i] = $gdcms_content_path . $filename;
            }
            continue;
        }
        if(strstr($designator, 'e401')) { //is custom error 401
            if(!$accessdenied && !is_dir($gdcms_content_path . $filename)) {
                $_gdcms_error_title_401 = $title;
                $_gdcms_error_file_401  = $gdcms_content_path . $filename;
            }
            continue;
        }
        if(strstr($designator, 'e403')) { //is custom error 401
            if(!$accessdenied && !is_dir($gdcms_content_path . $filename)) {
                $_gdcms_error_title_403 = $title;
                $_gdcms_error_file_403  = $gdcms_content_path . $filename;
            }
            continue;
        }
        if(strstr($designator, 'e404')) { //is custom error 401
            if(!$accessdenied && !is_dir($gdcms_content_path . $filename)) {
                $_gdcms_error_title_404 = $title;
                $_gdcms_error_file_404  = $gdcms_content_path . $filename;
            }
            continue;
        }

        //if it has a valid index, add the element to menu_titles...
        if($index > 0 && !$hidden && !$accessdenied) {
            $_gdcms_menu_titles[$level][$index] = $title;
        }

        //try to match it to targettitle, regardless of whether it has a menu index...
        $match = FALSE;
        if(isset($targettitle)) {
            if(strcasecmp($title, $targettitle)==0) {
                $match = TRUE;
            }
        } else if($default) {
            $match = TRUE;
        } else if($index == 1) {
            $match = TRUE;
        }
        if($match) { 
            if($accessdenied) {
                if(isset($candidateaccessdenied) && !$candidateaccessdenied)
                    $match = FALSE; //don't replace an accessible match with an inaccessible one!
            } else if(!$authrequired) { //give priority to access-granted pages that require auth flags
                if(isset($candidateauthrequired) && $candidateauthrequired)
                    $match = FALSE;
            }
        }
        if($match) {
            $_gdcms_level_index[$level] = $index;
            $candidatefile = $filename;
            $_gdcms_level_title[$level] = $title;
            $candidateredirect = $redirect;
            $candidateaccessdenied = $accessdenied;
            $candidateauthrequired = $authrequired;
        }
        
    }


    if(isset($candidatefile)) {
        if(!$candidateaccessdenied) {
            $gdcms_content_path .= $candidatefile;
            if(is_dir($gdcms_content_path))
                $gdcms_content_path .= '/'; //add trailing slash to directory
            else if($candidateredirect) {
                header('Location: ' . file_get_contents($gdcms_content_path));
                exit();
            } else { //we have a leaf node!
                $_gdcms_http_status = 200; //OK (because content found)
                break;
            }
        } else {
            $_gdcms_http_status = 401;
            $_gdcms_level_title[$level] = isset($_gdcms_error_title_401) ?  $_gdcms_error_title_401 : '[Unauthorized]';
            header('HTTP/1.1 401 Unauthorized'); //this is non-standard use of 401 error, but it's not inappropriate.
            break;
        }
    } else {
        if($_gdcms_last_level_specified == $level) {
            $_gdcms_http_status = 404;
            $_gdcms_level_title[$level] = isset($_gdcms_error_title_404) ?  $_gdcms_error_title_404 : '[Not found]';
            header('HTTP/1.0 404 Not Found');
        } else {
            $_gdcms_http_status = 403;
            $_gdcms_level_title[$level] = isset($_gdcms_error_title_403) ? $_gdcms_error_title_403 : '[Not found]';
            header('HTTP/1.1 403 Forbidden');
        }
        break;
    }
}
$depth = $level;


function gdcms_place_title($level=0) {
    global $_gdcms_level_title;
    global $depth;
    if(!$level) $level=$depth;
    if($level <= $depth) echo $_gdcms_level_title[$level];
}

function gdcms_place_content() {
    global $_gdcms_http_status;
    global $gdcms_content_path;
    global $_gdcms_error_file_401, $_gdcms_error_file_403, $_gdcms_error_file_404;

    if($_gdcms_http_status == 200) //is it a leaf node?
        include($gdcms_content_path);
    else if($_gdcms_http_status == 401) {
        if(isset($_gdcms_error_file_401))
            include($_gdcms_error_file_401);
        else
            echo '<h1>Error<sub>401</sub></h1>Unauthorized.';
    } else if($_gdcms_http_status == 404) {
        if(isset($_gdcms_error_file_404))
            include($_gdcms_error_file_404);
        else
            echo '<h1>Error<sub>404</sub></h1>The location wasn\'t found.';
    } else {
        if(isset($_gdcms_error_file_403))
            include($_gdcms_error_file_403);
        else
            echo '<h1>Error<sub>403</sub></h1>There is no default content to browse at this level.';
    }
}

function _gdcms_encode($url) {
    global $gdcms_double_encode;
    if($gdcms_double_encode)
        return urlencode(urlencode($url));
    return urlencode($url);
}

function gdcms_place_menu($level=0, $delim=' ') {
    global $_gdcms_menu_titles;
    global $_gdcms_level_index;
    global $_gdcms_level_title;
    global $_gdcms_last_level_specified;
    global $gdcms_url_rewrite;
    global $gdcms_href_prefix;
    global $depth;

    if(!$level) $level = $depth;

    if(isset($_gdcms_menu_titles[$level])) {
        $isfirstitem = TRUE;
        foreach ($_gdcms_menu_titles[$level] as $i => $title) { //print each link in order
            if(!$isfirstitem)
                echo $delim;
            $isfirstitem = FALSE;
            echo "<span id=\"menul{$level}s{$i}\" class=\"menuitem";
            $isactiveitem = ($i == $_gdcms_level_index[$level]);
            if($isactiveitem) echo ' menuactiveitem';
            echo "\">";
            if(!$isactiveitem || $level != $_gdcms_last_level_specified) {
                echo '<a href="' . $gdcms_href_prefix;
                if(!$gdcms_url_rewrite) echo '?'; else echo '/';
                for ($j=1; $j<$level; $j++) {
                    echo !$gdcms_url_rewrite ? "l$j=" : '';
                    echo _gdcms_encode($_gdcms_level_title[$j]);
                    echo $gdcms_url_rewrite ? '/' : '&';
                }
                echo !$gdcms_url_rewrite ? "l$level=" : '';
                echo _gdcms_encode($title);
                echo '">';
                echo $title;
                echo '</a>';
            }
            else {
                echo $title;
            }
            echo '</span>';
        }
    }
}

function gdcms_place_template($templatetitle) {
    global $_gdcms_template_title;
    global $_gdcms_template_file;

    if(!isset($_gdcms_template_title)) return;
    foreach($_gdcms_template_title as $i => $title)  //search for the template
        if(strcasecmp($title, $templatetitle)==0) {
            include($_gdcms_template_file[$i]);
            break;
        }
}

function gdcms_place_promo() {
    echo '<a href="http://generaldevelopment.net/gdcms" title="The free, bloat-free, web content management system.">Powered by GD-CMS v2.</a>';
}


?>
